//
//  CRPathHolder.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 3/31/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

#import "CRSceneItemBase.h"

extern NSString* const CRPathHolderTensionKey;
extern NSString* const CRPathHolderPathKey;

//////////////////////////////////////////////////////////////////////
// CRPathWalkData
// Stores some data for path-walking
//////////////////////////////////////////////////////////////////////
@interface CRPathWalkData : NSObject<NSCopying>
{
	NSAffineTransform* areaTransform;	// transforms [0, 1] space to the area space
	CGFloat pathLength;					// precomputed path length
	NSUInteger index;					// point index in the array
	CGFloat t;							// lerp coefficient between this point and next one
}

@property (nonatomic, copy)	  NSAffineTransform*	areaTransform;
@property (nonatomic, assign) CGFloat				pathLength;
@property (nonatomic, assign) NSUInteger			index;
@property (nonatomic, assign) CGFloat				t;

@end

//////////////////////////////////////////////////////////////////////
// CRPathHolder
// Stores points in relative space [0, 1]
//////////////////////////////////////////////////////////////////////
typedef struct {
	NSPoint location;
	int index1;
	int index2;
	BOOL isHit;
} CRPathProjectionResult;

@interface CRPathHolder : CRSceneItemBase
{
	CRPathWalkData* walkData;	// current position
}

@property (nonatomic, assign) CGFloat	tension;	// "smooth" of the curve
@property (nonatomic, strong) NSArray*	path;		// path points

- (id)init;
+ (id)pathHolder;

- (float)preparePathForArea:(NSAffineTransform *)areaTransform;
- (void)movePathPosition:(float)offset;
- (NSPoint)currentPathPoint;
- (CRPathProjectionResult)closestPointToLocation:(NSPoint)location withTransform:(NSAffineTransform *)transform;

- (NSBezierPath *)bezierPathForPoints:(NSArray*)points area:(NSAffineTransform *)areaTransform closePath:(BOOL)close;
- (NSBezierPath *)bezierPathForArea:(NSAffineTransform *)areaTransform;

@end